/*:
 * @target MZ
 * @plugindesc Disable VisuStella Quest Tracker popup entirely.
 * @help
 * This plugin hides the Quest Tracker window (upper right popup).
 * The quest system still works, but the tracker will never display.
 */

(() => {
  if (typeof Window_QuestTracker !== "undefined") {
    // Force the tracker to always stay hidden
    Window_QuestTracker.prototype.update = function() {
      this.visible = false;
    };

    Window_QuestTracker.prototype.show = function() {
      this.visible = false;
    };

    Window_QuestTracker.prototype.open = function() {
      this.visible = false;
    };
  }
})();
